/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : DECADE COUNTER
TRUTHTABLE     : 

           SEE  NOTE 1                       SEE NOTE 2
          BCD COUNT SEQ.                     BI-QUINARY
         -------------------              -------------------   
         COUNT  QD QC QB QA               COUNT  QA QD QC QB
         -------------------              -------------------   
           0    L  L  L  L                  0    L  L  L  L     
           1    L  L  L  H                  1    L  L  L  H     
           2    L  L  H  L                  2    L  L  H  L     
           3    L  L  H  H                  3    L  L  H  H     
           4    L  H  L  L                  4    L  H  L  L     
           5    L  H  L  H                  5    H  L  L  L     
           6    L  H  H  L                  6    H  L  L  H     
           7    L  H  H  H                  7    H  L  H  L     
           8    H  L  L  L                  8    H  L  H  H     
           9    H  L  L  H                  9    H  H  L  L     
         -------------------              -------------------   

                               RESET/COUNT FUNCTION
                         --------------------------------------
                         R_0_1   R_0_2   R_9_1   R_9_2    QD QC QB QA
                         --------------------------------------
                          H     H     L     X     L  L  L  L
                          H     H     X     L     L  L  L  L
                          X     X     H     H     H  L  L  H
                          X     L     X     L        COUNT
                          X     L     L     X        COUNT
                          L     X     X     L        COUNT
                          L     X     L     X        COUNT
                         -------------------------------------
         NOTES : 1. QA IS CONNECTED TO INPUT B FOR BCD COUNT.
                 2. QD IS CONNECTED TO INPUT A FOR BI-QUINARY COUNT.
                               
REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a290 (r91, r92, qc, qb, qd, qa, cka, ckb, r01, r02);
	parameter size =1;
	parameter cds_action = "ignore";
	input
		r91,
		r92,
		cka,
		ckb,
		r01,
		r02;
	output
		qc,
		qb,
		qd,
		qa;
    reg
        NOTIFY_REG;
    and
	  (r0, r01, r02);
    and
	  (r9, r91, r92);
    and
	  (r0_1_en, r02, r9_);
    and
	  (r0_2_en, r01, r9_);
    not
	  (r9_, r9);
    nor
	  (en, r0, r9);
    nand  
	M290N_inst_N1 (m290n_inst_prb, r91, r92);
    nand  
	M290N_inst_N2 (m290n_inst_clrb, r01, r02);
    and
	M290N_inst_N3 (m290n_inst_wr3, m290n_inst_clrb, m290n_inst_prb);
    and
	M290N_inst_N4 (m290n_inst_wd, m290n_inst_qbint, m290n_inst_qcint);
    not
	  (m290n_inst_ncka, cka);
    not  
	  (m290n_inst_nckb, ckb);
    buf
	  (qa, m290n_inst_qaint1);
    buf  
	  (qb, m290n_inst_qbint);
    buf
	  (qc, m290n_inst_qcint);
    buf
	  (qd, m290n_inst_qdint);
    not
	  (m290n_inst_qbb, m290n_inst_qbint);
    not
	  (m290n_inst_qdb, m290n_inst_qdint);
    U_FT_P_SB_RB_NO  
	M290N_inst_Inst1_inst1 (m290n_inst_qaint1, m290n_inst_ncka, m290n_inst_clrb, m290n_inst_prb, NOTIFY_REG);
    U_FT_P_SB_RB_NO
	M290N_inst_Inst3_inst1 (m290n_inst_qcint1, m290n_inst_qbint, m290n_inst_wr3, 1'b1, NOTIFY_REG);
    U_FD_P_RB_NO  
	M290N_inst_Inst4_inst1 (m290n_inst_qcint, m290n_inst_qcint1, m290n_inst_qbb, m290n_inst_wr3, NOTIFY_REG);
    U_FJK_P_RB_NO
	  (m290n_inst_qbint1, m290n_inst_qdb, 1'b1, ckb, m290n_inst_wr3, NOTIFY_REG);
    U_FD_P_RB_NO
	M290N_inst_Inst6_inst1 (m290n_inst_qbint, m290n_inst_qbint1, m290n_inst_nckb, m290n_inst_wr3, NOTIFY_REG);
    U_FJK_P_SB_RB_NO
	M290N_inst_Inst7_inst1 (m290n_inst_qdint1, m290n_inst_wd, m290n_inst_qdint, ckb, m290n_inst_clrb, m290n_inst_prb, NOTIFY_REG);
    U_FD_P_SB_RB_NO  
	  (m290n_inst_qdint, m290n_inst_qdint1, m290n_inst_nckb, m290n_inst_clrb, m290n_inst_prb, NOTIFY_REG);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
